// $Id: CTimeSignature.cpp,v 1.6 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTimeSignature.hpp"
using Exponent::Music::CTimeSignature;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTimeSignature, CCountedObject);

//	===========================================================================
CTimeSignature::CTimeSignature(const long numerator, const long denominator) : m_numerator(numerator), m_denominator(denominator)
{
	EXPONENT_CLASS_CONSTRUCTION(CTimeSignature);
	this->setTimeSignature(numerator, denominator);
}

//	===========================================================================
CTimeSignature::CTimeSignature(const CTimeSignature &timeSig) : m_numerator(4), m_denominator(4)
{
	EXPONENT_CLASS_CONSTRUCTION(CTimeSignature);
	this->setTimeSignature(timeSig.getNumerator(), timeSig.getDenominator());
}

//	===========================================================================
CTimeSignature::~CTimeSignature()
{
	EXPONENT_CLASS_DESTRUCTION(CTimeSignature);
}

//	===========================================================================
CTimeSignature &CTimeSignature::operator = (const CTimeSignature &timeSig)
{
	this->setTimeSignature(timeSig.getNumerator(), timeSig.getDenominator());
	return *this;
}

//	===========================================================================
void CTimeSignature::setTimeSignature(const long numerator, const long denominator)
{
	m_numerator   = numerator;
	m_denominator = denominator;
}

//	===========================================================================
void CTimeSignature::setNumerator(const long numerator)
{
	m_numerator = numerator;
}

//	===========================================================================
void CTimeSignature::setDenominator(const long denominator)
{
	m_denominator = denominator;
}

//	===========================================================================
long CTimeSignature::getDenominator() const
{ 
	return m_denominator; 
}

//	===========================================================================
long CTimeSignature::getNumerator() const   
{ 
	return m_numerator;
}

//	===========================================================================
double CTimeSignature::getAsDecimal() const
{ 
	return m_numerator / m_denominator;
}